 /*******************************************************************
 *
 *  DESCRIPTION: Atomic Model Base Station Queue
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 25/10/2012
 *
 *******************************************************************/
 #include "BSqueue0.h"      // class BSQueue
 #include "message.h"    // class ExternalMessage, InternalMessage
 #include <iostream>
 #include <fstream>
  ofstream BQI ("BS0QIn.txt");
  ofstream BQO ("BS0QOut.txt");

 BSQueue0::BSQueue0( const string &name ) : Atomic( name )
 , IB1( addInputPort( "IB1" ) )
 , IB2( addInputPort( "IB2" ) )
 , IB3( addInputPort( "IB3" ) )
 , IB4( addInputPort( "IB4" ) )
 , IB5( addInputPort( "IB5" ) )
 , IB6( addInputPort( "IB6" ) )
 , IU0( addInputPort( "IU0" ) )
 , Req( addInputPort( "Req" ) )
 , Out( addInputPort( "Out" ) )
 , ProcessTime (00,00,00,00)
 {
 }

 Model &BSQueue0::initFunction()
 {
   Request = 0;
   Qlen = 0;
   state = Idle;
   elements.erase( elements.begin(), elements.end() ) ;
   passivate();
   return *this ;
 }

 Model &BSQueue0::externalFunction( const ExternalMessage &msg )
 { BQI <<msg.time()<<" "<<msg.value()<<"\n";
   if( msg.port() != Req ) // Input from In1 or In2 or In3 or In4
	 {
	   elements.push_back( msg.value() ) ; //Store Input value in Queue
	   state = Push;
	   Qlen++;
	   holdIn( Atomic::active, ProcessTime);
	 }
     else if (elements.size() > 0)  //So msg.port() == Req  ===> Pop from Queue (Check that the Queue is not empty)
          	 {
    	       Request = 1;
    	       state = Pop;
    	       holdIn( Atomic::active, ProcessTime);
      	     }
             else if (elements.size() == 0)
            	     {      // Here this two condition are True :(msg.port() == Req) & (elements.size() == 0)
            	       Request = 1;   // Although Queue is empty but remember that server is waiting for input.
            	       passivate();   // If the queue is empty then passivate.
            	     }
   return *this;
 }

 Model &BSQueue0::outputFunction( const InternalMessage &msg )
 {
   if ((state == Pop) && (Request == 1))
   {
	 sendOutput( msg.time(), Out, elements.front());  // Send out data from Queue
	 BQO <<msg.time()<<" Out "<<elements.front()<<"\n";
   }

   return *this ;
 }

 Model &BSQueue0::internalFunction( const InternalMessage & )
 {
   switch (state){
   				    case Idle:
   				    	       if (Request == 1) state = Pop;
   				    	         else passivate();
   					           break;

   				    case Push:
 			    	            state = Idle;
   					            break;

   				    case Pop:
   				    	       elements.pop_front();
   				    	       Qlen--;
   				    	       Request = 0;
   				    	       state = Idle;
   					           break;
           		 }
   return *this;
 }

 BSQueue0::~BSQueue0()
 {
 }
